
---

# Jury-and-Judge Chain-of-Thought for Uncovering Toxic Data in 3D Visual Grounding

This repository contains the official code and instructions for reproducing the results of our submission:
**"Jury-and-Judge Chain-of-Thought for Uncovering Toxic Data in 3D Visual Grounding"**.

---

## 📁 Project Structure

```
Refer_Judge/
├── data/                          # Dataset directory
│   ├── ScanNet/                   # Place official ScanNet data here
│   └── ScanRefer/                # Place official ScanRefer data here
│
├── data_preprocessing/           # Data preprocessing scripts
│   ├── image_find_misleading_frames.py
│   ├── image_find_target_frames.py
│   └── preprocess_data.py        # Main preprocessing entry
│
├── jury_and_judge/               # Core pipeline scripts
│   ├── call_llms.py              # LLM calling interface
│   ├── config.py                 # Config file to modify before execution
│   ├── refer_judge.py            # Main end-to-end execution script
│   ├── ref_jobs.py               # Task orchestration
│   └── SYSTEM_MESSAGE.py         # System prompt design
│
├── outputs/                      # Output directory
│
├── ScanRefer_Justice/
│   ├── ScanRefer_Justice.json    # The ScanRefer_Justice dataset
│   └── LICENSE                  # The LICENSE of our proposed ScanRefer_Justice dataset
│
├── utils/                        # Utilities
│   └── Projection/               # 3D projection and helper tools
```

---

## 🚀 Getting Started

### 1. Prerequisites

* Python ≥ 3.8
* Install required packages:

```bash
pip install -r requirements.txt
```

Note: The exact `requirements.txt` may vary depending on your setup.

---

## 📦 Data Preparation

### Step 1: Download the datasets

Please manually download the following datasets from their **official sources**:

* **ScanNet**: [http://www.scan-net.org/](http://www.scan-net.org/)

The ScanNet should be organized as follows：
```
ScanNet_ROOT/
├── scans/                  # including train and val set
│   ├── scene0000_00/
│   │   ├── scene0000_00_vh_clean.ply
│   │   ├── scene0000_00.aggregation.json
│   │   └── ...
│   ├── scene0001_00/
│   └── ...
├── scans_test/
│   └── ...
└── scannet_frames_25k/
    ├── scene0000_00/
    │   ├── color/
    │   ├── depth/
    │   ├── instance/
    │   └── ...
    ├── scene0001_00/
    └── ...
```

* **ScanRefer**: [https://github.com/daveredrum/ScanRefer](https://github.com/daveredrum/ScanRefer)

Place the downloaded data in the `data/ScanNet/` and `data/ScanRefer/` directories respectively.

---

### Step 2: Preprocess the Data

Run the preprocessing script to prepare `ScanRefer_Justice` subset used for toxic data analysis:

```bash
python data_preprocessing/preprocess_data.py
```

This step is used to search for positive and misleading frames corresponding to 3DVG samples.

---

## 🔍 Running the Refer-Judge

### Step 3: Configure the pipeline

Edit `jury_and_judge/config.py` to specify paths, OpenAI keys, model preferences, and other runtime settings.

---

### Step 4: Run the end-to-end pipeline

Execute the following script to perform CoT-based toxic data identification:

```bash
python jury_and_judge/ref_end_2_end.py
```

Intermediate processing will be printed, and final results will be saved to:

```
outputs/
```

This file contains the full set of "judgments" for each 3DVG sample.

---


